---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-フォームレイアウト（Bootstrap 3 水平）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張が根拠付き）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_3_horizontal_layout.html.twig` L1-68
- E-02: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_3_layout.html.twig` L1-217
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行47（No.46のエントリ）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行118-119（No.46の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bootstrap_3_layoutをuseタグで読み込む | E-01 L1 | ○ |
| C-02 | form_startでform-horizontalクラスを追加 | E-01 L3-6 | ○ |
| C-03 | form_labelにcol-sm-2クラスを追加 | E-01 L10-17 | ○ |
| C-04 | label=falseで空div.col-sm-2を出力 | E-01 L11-12 | ○ |
| C-05 | form_label_classがcol-sm-2 | E-01 L19-21 | ○ |
| C-06 | form_row_renderで水平グリッド構造を生成 | E-01 L25-34 | ○ |
| C-07 | submit_rowでラベル列空+フィールド列にボタン | E-01 L36-43 | ○ |
| C-08 | reset_rowでsubmit_rowと同構造 | E-01 L45-52 | ○ |
| C-09 | form_group_classがcol-sm-10 | E-01 L54-56 | ○ |
| C-10 | checkbox_rowで水平配置 | E-01 L58-67 | ○ |
| C-11 | 4層の継承構造 | E-01 L1, E-02 L1 | ○ |
| C-12 | 関連機能：Form、Twig Bridge | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 68行の小規模テンプレートで全行を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] グリッドクラス（col-sm-2 / col-sm-10）が正確か確認
- [ ] form-horizontalクラスの適用位置が正確か確認
